topic "Exec";
[2 $$0,0#00000000000000000000000000000000:Default]
[i448;a25;kKO9;2 $$1,0#37138531426314131252341829483380:class]
[l288;2 $$2,2#27521748481378242620020725143825:desc]
[0 $$3,0#96390100711032703541132217272105:end]
[H6;0 $$4,0#05600065144404261032431302351956:begin]
[i448;a25;kKO9;2 $$5,0#37138531426314131252341829483370:item]
[l288;a4;*@5;1 $$6,6#70004532496200323422659154056402:requirement]
[l288;i1121;b17;O9;~~~.1408;2 $$7,0#10431211400427159095818037425705:param]
[i448;b42;O9;2 $$8,8#61672508125594000341940100500538:tparam]
[b42;2 $$9,9#13035079074754324216151401829390:normal]
[{_} 
[ {{10000@(113.42.0) [s0;%% [*@7;4 Exec]]}}&]
[s0; &]
[s1;:Upp`:`:Exec`:`:class: [@(0.0.255)3 class][3 _][*3 Exec][3 _:_][@(0.0.255)3 public][3 _][*@3;3 C
hannel]&]
[s2;%% This class encapsulates a remote process execution (exec) 
channel. It provides a means for executing processes on remote 
hosts.&]
[s3; &]
[ {{10000F(128)G(128)@1 [s0;%% [* Public Method List]]}}&]
[s3; &]
[s5;:Upp`:`:Exec`:`:Execute`(const Upp`:`:String`&`,Upp`:`:Stream`&`,Upp`:`:Stream`&`): [@(0.0.255) i
nt]_[* Execute]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 cmd], 
[_^Upp`:`:Stream^ Stream][@(0.0.255) `&]_[*@3 out], [_^Upp`:`:Stream^ Stream][@(0.0.255) `&
]_[*@3 err])&]
[s5;:Upp`:`:Exec`:`:operator`(`)`(const Upp`:`:String`&`,Upp`:`:Stream`&`,Upp`:`:Stream`&`): [@(0.0.255) i
nt]_[* operator()]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 cmd], 
[_^Upp`:`:Stream^ Stream][@(0.0.255) `&]_[*@3 out], [_^Upp`:`:Stream^ Stream][@(0.0.255) `&
]_[*@3 err])&]
[s2;%% Executes remote process defined by [%-*@3 cmd] command line, 
returns its standard output in [%-*@3 out], its standard error 
output in [%-*@3 err], and its exit code as return value. If the 
execution fails, specific error code and message can be retrieved 
using [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:GetError`(`)const^ G
etError()] and [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:GetErrorDesc`(`)const^ G
etErrorDesc()] methods. &]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:Exec`:`:StartExecute`(const Upp`:`:String`&`,Upp`:`:Stream`&`,Upp`:`:Stream`&`): [_^Upp`:`:Exec^ E
xec][@(0.0.255) `&]_[* StartExecute]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&
]_[*@3 cmd], [_^Upp`:`:Stream^ Stream][@(0.0.255) `&]_[*@3 out], [_^Upp`:`:Stream^ Stream][@(0.0.255) `&
]_[*@3 err])&]
[s2;%% Asynchronous variant of [^topic`:`/`/SSH`/src`/Ssh`_Exec`$en`-us`#Upp`:`:Exec`:`:Execute`(const Upp`:`:String`&`,Upp`:`:Stream`&`,Upp`:`:Stream`&`)^ E
xecute()]. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining. &]
[s2;%% [* Caution]: Object life time is a crucial parameter to take 
into account here. Do not let the calls to [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] method outlive the [%-*@3 out ]and [%-*@3 err ]Streams. Otherwise 
your application will crash.&]
[s3;%% &]
[s3; &]
[ {{10000F(128)G(128)@1 [s0;%% [* Constructor detail]]}}&]
[s3; &]
[s5;:Upp`:`:Exec`:`:Exec`(`): [* Exec]()&]
[s2;%% Default constructor. In order for the Exec instances constructed 
this way to be valid, they must be bound to a valid ssh session 
first, using [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:Subsystem`:`:Session`(Upp`:`:Ssh`&`)^ S
ubsystem`::Session()] method. &]
[s3; &]
[s4; &]
[s5;:Upp`:`:Exec`:`:Exec`(Upp`:`:Ssh`&`): [* Exec]([_^Upp`:`:Ssh^ Ssh][@(0.0.255) `&]_[*@3 se
ssion])&]
[s2;%% Equivalent of the default constructor and then invoking [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:Subsystem`:`:Session`(Upp`:`:Ssh`&`)^ S
ubsystem`::Session()]. Binds the Exec instance to a given ssh 
[%-*@3 session]. Using this constructor is recommended.&]
[s3;%% ]]